<?php
extract( shortcode_atts( array(
	'style' => '',
	'items' => '',
	'name_color' => '',
	'title_color' => '',
	'text_color' => '',
	'link_color' => '',
	'show_nav' => 'yes',
	'show_pagination' => '',
	'el_class' => '',
), $atts ) );

$css_class = array( 'sm-team-slider', 'sm_content_element', 'clearfix' );

$style = sm_validate_with_array( $style, sm_get_team_slider_styles_array() );
$GLOBALS['sm-team-slider-style'] = $style;
$css_class[] = $style;
if ( 'yes' == $show_nav ) $css_class[] = 'has-nav';

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );
$items = sm_validate_with_array( $items, sm_get_team_slider_items_array() );

$scoped_css = '';
$id = sm_shortcode_unique_id( 'sm-team-slider' );
$css_gen = new Inline_CSS_Generator( "sm-team-slider", $id );
if ( !empty( $name_color ) ) {
	$scoped_css .= $css_gen->css( '.member-name', array( 'color' => $name_color ) );
}
if ( !empty( $title_color ) ) {
	$scoped_css .= $css_gen->css( '.member-title', array( 'color' => $title_color ) );
}
if ( !empty( $text_color ) ) {
	$scoped_css .= $css_gen->css( '.member-dscr', array( 'color' => $text_color ) );
}
if ( !empty( $link_color ) ) {
	$scoped_css .= $css_gen->css( 
		array( '.member-social-link', '.nav-control' ), 
		array( 'color' => $link_color, 'border-color' => $link_color ) );
	$scoped_css .= $css_gen->css( 
		array( '.team-slider-pagination a' ), 
		array( 'background-color' => $link_color ) );
}
$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
$wrapper_attributes[] = 'data-items="' . esc_attr( $items ) . '"';
if ( $show_nav ) {
	$wrapper_attributes[] = 'data-show-nav="true"';
}
if ( $show_pagination ) {
	$wrapper_attributes[] = 'data-show-pg="true"';
}
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
	<div class="team-slider-wrap">
		<div class="team-slider-carousel">
			<?php echo sm_js_remove_wpautop( $content, true ); ?>
		</div>
		<?php if ( 'yes' == $show_nav ) : ?>
		<div class="team-slider-nav">
			<a class="nav-control prev" href='#'></a>
			<a class="nav-control next" href='#'></a>
		</div>
		<?php endif; ?>
	</div>
	<?php if ( 'yes' == $show_pagination ) : ?>
	<div class="team-slider-pagination"></div>
	<?php endif; ?>
	
</div>